namespace Microsoft.Samples.PlanMyNight.Data.Caching.Tests
{
    using System;
    using System.Collections.Generic;
    using Microsoft.Samples.PlanMyNight.Entities;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Moq;

    [TestClass]
    public class CachedReferenceRepositoryFixture
    {
        [TestMethod]
        public void RetrieveStatesFromPrimedCache()
        {
            var cacheProvider = new Mock<ICachingProvider>();
            cacheProvider.Setup(o => o.Get("Reference", "states")).Returns(null);
            cacheProvider.Setup(o => o.Add("Reference", "states", It.IsAny<IEnumerable<State>>(), It.IsAny<TimeSpan>()));

            var sourceRepo = new Mock<IReferenceRepository>();
            sourceRepo.Setup(o => o.RetrieveStates()).Returns(new State[0]);

            var cache = new CachedReferenceRepository(cacheProvider.Object, sourceRepo.Object);
            var result = cache.RetrieveStates();

            Assert.IsNotNull(result);
            sourceRepo.VerifyAll();
            cacheProvider.VerifyAll();
        }

        [TestMethod]
        public void RetrieveStatesFromCache()
        {
            var cacheProvider = new Mock<ICachingProvider>();
            cacheProvider.Setup(o => o.Get("Reference", "states")).Returns(new State[0]);

            var cache = new CachedReferenceRepository(cacheProvider.Object, new Mock<IReferenceRepository>().Object);
            var result = cache.RetrieveStates();

            Assert.IsNotNull(result);
            cacheProvider.VerifyAll();
        }

        [TestMethod]
        public void RetrieveZipCodesFromPrimedCache()
        {
            var cacheProvider = new Mock<ICachingProvider>();
            cacheProvider.Setup(o => o.Get("Reference", "zipcodes-ny")).Returns(null);
            cacheProvider.Setup(o => o.Add("Reference", "zipcodes-ny", It.IsAny<IEnumerable<string>>(), It.IsAny<TimeSpan>()));

            var sourceRepo = new Mock<IReferenceRepository>();
            sourceRepo.Setup(o => o.RetrieveZipCodes("NY")).Returns(new string[0]);

            var cache = new CachedReferenceRepository(cacheProvider.Object, sourceRepo.Object);
            var result = cache.RetrieveZipCodes("NY");

            Assert.IsNotNull(result);
            sourceRepo.VerifyAll();
            cacheProvider.VerifyAll();
        }

        [TestMethod]
        public void RetrieveZipCodesFromCache()
        {
            var cacheProvider = new Mock<ICachingProvider>();
            cacheProvider.Setup(o => o.Get("Reference", "zipcodes-ny")).Returns(new State[0]);

            var cache = new CachedReferenceRepository(cacheProvider.Object, new Mock<IReferenceRepository>().Object);
            var result = cache.RetrieveZipCodes("NY");

            Assert.IsNotNull(result);
            cacheProvider.VerifyAll();
        }

        [TestMethod]
        public void RetrieveCitiesFromPrimedCache()
        {
            var cacheProvider = new Mock<ICachingProvider>();
            cacheProvider.Setup(o => o.Get("Reference", "cities-ny")).Returns(null);
            cacheProvider.Setup(o => o.Add("Reference", "cities-ny", It.IsAny<IEnumerable<string>>(), It.IsAny<TimeSpan>()));

            var sourceRepo = new Mock<IReferenceRepository>();
            sourceRepo.Setup(o => o.RetrieveCities("NY")).Returns(new string[0]);

            var cache = new CachedReferenceRepository(cacheProvider.Object, sourceRepo.Object);
            var result = cache.RetrieveCities("NY");

            Assert.IsNotNull(result);
            sourceRepo.VerifyAll();
            cacheProvider.VerifyAll();
        }

        [TestMethod]
        public void RetrieveCitiesFromCache()
        {
            var cacheProvider = new Mock<ICachingProvider>();
            cacheProvider.Setup(o => o.Get("Reference", "cities-ny")).Returns(new State[0]);

            var cache = new CachedReferenceRepository(cacheProvider.Object, new Mock<IReferenceRepository>().Object);
            var result = cache.RetrieveCities("ny");

            Assert.IsNotNull(result);
            cacheProvider.VerifyAll();
        }
    }
}
